/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.contentAssist.ContentAssistUtils;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.CommentsVisitor;
import com.aptana.editor.php.internal.indexer.Messages;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import com.aptana.editor.php.internal.parser.phpdoc.FunctionDocumentation;
import com.aptana.editor.php.internal.parser.phpdoc.TypedDescription;
import com.aptana.editor.php.util.EncodingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ASTParser;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org2.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDoc;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;

public final class PHPDocUtils {
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final String DOLLAR = "$";
    private static final String EMPTY_STRING = "";
    private static final Pattern INPUT_TAG_PATTERN = Pattern.compile("<input[^>]*/>|<input\\s*>");

    public static PHPDocBlock findFunctionPHPDocComment(IElementEntry entry, IDocument document, int offset) {
        boolean isParameter;
        boolean bl = isParameter = entry.getValue() instanceof VariablePHPEntryValue && ((VariablePHPEntryValue)entry.getValue()).isParameter();
        if (entry.getModule() != null) {
            return PHPDocUtils.findFunctionPHPDocComment(entry.getModule(), document, offset, isParameter);
        }
        try {
            InputStream stream;
            String entryPath = entry.getEntryPath();
            if (entryPath != null && (stream = PHPBuiltins.getInstance().getBuiltinResourceStream(entryPath)) != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                return PHPDocUtils.innerParsePHPDoc(offset, reader, isParameter);
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Failed locating the PHP function doc", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static PHPDocBlock findFunctionPHPDocComment(IModule module, IDocument document, int offset, boolean isParameter) {
        try {
            Reader innerReader = document != null ? new StringReader(document.get()) : new InputStreamReader(module.getContents(), EncodingUtils.getModuleEncoding(module));
            BufferedReader reader = new BufferedReader(innerReader);
            return PHPDocUtils.innerParsePHPDoc(offset, reader, isParameter);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static PHPDocBlock innerParsePHPDoc(int offset, BufferedReader reader, boolean isParameter) throws IOException, Exception {
        ASTNode node;
        String str;
        StringBuffer moduleData = new StringBuffer();
        try {
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                moduleData.append(readData);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a BufferedReader in the PDTPHPModuleIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                }
            }
        }
        String contents = moduleData.toString();
        int b = -1;
        int a = offset;
        while (a >= 0) {
            char c = contents.charAt(a);
            if (c == '(') {
                b = a;
                break;
            }
            if (c == '\r' || c == '\n') {
                b = a;
                break;
            }
            --a;
        }
        if (b != -1 && (str = contents.substring(b, offset)).indexOf(59) == -1) {
            offset = b;
        }
        PHPVersion version = PHPVersionProvider.getDefaultPHPVersion();
        ASTParser parser = ASTParser.newParser((Reader)new StringReader(contents), (PHPVersion)version, (boolean)true);
        Program program = parser.createAST(null);
        CommentsVisitor commentsVisitor = new CommentsVisitor();
        program.accept((Visitor)commentsVisitor);
        List<Comment> _comments = commentsVisitor.getComments();
        PHPDocBlock docBlock = PHPDocUtils.findPHPDocComment(_comments, offset, contents);
        if (docBlock == null && isParameter && (node = program.getElementAt(offset)) instanceof FunctionDeclaration) {
            offset = node.getStart();
            if (node.getParent() instanceof MethodDeclaration) {
                offset = node.getParent().getStart();
            }
            docBlock = PHPDocUtils.findPHPDocComment(_comments, offset, contents);
        }
        return docBlock;
    }

    public static FunctionDocumentation getParameterDocumentation(IPHPDoc block, String parameterName) {
        if (block == null) {
            return null;
        }
        FunctionDocumentation result = new FunctionDocumentation();
        IPHPDocTag[] tags = block.getTags();
        if (tags != null) {
            IPHPDocTag[] iPHPDocTagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPDocTag tag = iPHPDocTagArray[n2];
                switch (tag.getTagKind()) {
                    case 7: {
                        String[] parsedTag;
                        String value = tag.getValue();
                        if (value == null || (StringUtil.isEmpty((String)(parsedTag = PHPDocUtils.parseParamTagValue(value))[2]) || !parsedTag[2].startsWith(parameterName)) && (StringUtil.isEmpty((String)parsedTag[0]) || !parsedTag[0].startsWith(PHPDocUtils.removeDollar(parameterName)))) break;
                        result.setDescription(String.valueOf('\n') + value);
                        return result;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static FunctionDocumentation getFunctionDocumentation(IPHPDoc block) {
        if (block == null) {
            return null;
        }
        FunctionDocumentation result = new FunctionDocumentation();
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(block.getShortDescription());
        String longDescription = block.getLongDescription();
        if (!StringUtil.isEmpty((String)longDescription)) {
            docBuilder.append('\n');
            docBuilder.append(longDescription);
        }
        result.setDescription(docBuilder.toString());
        IPHPDocTag[] tags = block.getTags();
        if (tags != null) {
            IPHPDocTag[] iPHPDocTagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPDocTag tag = iPHPDocTagArray[n2];
                switch (tag.getTagKind()) {
                    case 12: {
                        String value = tag.getValue();
                        if (value == null) break;
                        TypedDescription typeDescr = new TypedDescription();
                        typeDescr.addType(value);
                        result.addVar(typeDescr);
                        break;
                    }
                    case 7: {
                        String value = tag.getValue();
                        if (value == null) break;
                        String[] parsedValue = PHPDocUtils.parseParamTagValue(value);
                        TypedDescription typeDescr = new TypedDescription();
                        typeDescr.setName(parsedValue[0]);
                        if (parsedValue[1] != null) {
                            typeDescr.addType(parsedValue[1]);
                        }
                        if (parsedValue[2] != null) {
                            typeDescr.setDescription(parsedValue[2]);
                        }
                        result.addParam(typeDescr);
                        break;
                    }
                    case 6: {
                        String[] returnTypes;
                        String returnTagValue = tag.getValue().trim();
                        if (returnTagValue == null) break;
                        String[] stringArray = returnTypes = returnTagValue.split("\\|");
                        int n3 = returnTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String returnType = stringArray[n4];
                            returnTagValue = PHPDocUtils.clean(returnType.trim());
                            returnTagValue = PHPDocUtils.firstWord(returnTagValue);
                            result.getReturn().addType(returnTagValue);
                            ++n4;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static VarComment findTypedVarComment(List<Comment> comments, int offset, String content) {
        Comment c = PHPDocUtils.getCommentByType(comments, offset, content, 1);
        if (c instanceof VarComment) {
            return (VarComment)c;
        }
        return null;
    }

    public static PHPDocBlock findPHPDocComment(List<Comment> comments, int offset, String content) {
        return (PHPDocBlock)PHPDocUtils.getCommentByType(comments, offset, content, 2);
    }

    public static Comment getCommentByType(List<Comment> comments, int offset, String content, int type) {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        Comment nearestComment = null;
        int commentIndex = PHPDocUtils.findUpperComment(comments, offset);
        if (commentIndex < 0) {
            nearestComment = comments.get(-commentIndex - 1);
        }
        if (nearestComment == null) {
            return null;
        }
        if (type != -1 && (nearestComment.getCommentType() & type) == 0) {
            return null;
        }
        if (content != null) {
            if (offset - 2 < 0 || nearestComment.getEnd() >= content.length() || offset - 2 >= content.length()) {
                return null;
            }
            int i = nearestComment.getEnd() + 1;
            while (i < offset - 1) {
                char ch = content.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    return null;
                }
                ++i;
            }
        }
        return nearestComment;
    }

    public static int findComment(List<Comment> comments, int offset) {
        int low = 0;
        int high = comments.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Comment midVal = comments.get(mid);
            if (offset >= midVal.getStart() && offset < midVal.getEnd()) {
                return mid;
            }
            int cmp = midVal.getStart() - offset;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static int findUpperComment(List<Comment> comments, int offset) {
        int low = 0;
        int high = comments.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comment midVal = comments.get(mid);
            int cmp = midVal.getStart() - offset;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    private static String firstWord(String str) {
        int firstSpacePos = -1;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                firstSpacePos = i;
                break;
            }
            ++i;
        }
        if (firstSpacePos == -1) {
            return str;
        }
        if (firstSpacePos == 0) {
            return EMPTY_STRING;
        }
        return str.substring(0, firstSpacePos);
    }

    private static String[] parseParamTagValue(String toParse) {
        if (toParse == null || toParse.length() == 0) {
            return null;
        }
        String[] parts = toParse.split("\\s+");
        if (parts == null || parts.length == 0) {
            return null;
        }
        String[] result = new String[3];
        boolean isJSLike = false;
        if (parts[0].contains(OPEN_BRACKET) || parts[0].contains(CLOSE_BRACKET)) {
            isJSLike = true;
        }
        if (parts[0].contains(DOLLAR)) {
            isJSLike = true;
        }
        if (parts.length > 1 && parts[1].contains(DOLLAR)) {
            isJSLike = true;
        }
        if (isJSLike) {
            if (parts.length == 1) {
                result[0] = PHPDocUtils.clean(parts[0]);
            } else if (parts.length == 2) {
                result[0] = PHPDocUtils.clean(parts[1]);
                result[1] = PHPDocUtils.clean(parts[0]);
            } else {
                result[0] = PHPDocUtils.clean(parts[1]);
                result[1] = PHPDocUtils.clean(parts[0]);
                StringBuffer buf = new StringBuffer();
                int i = 2;
                while (i < parts.length) {
                    buf.append(parts[i]);
                    if (i != parts.length) {
                        buf.append(' ');
                    }
                    ++i;
                }
                result[2] = buf.toString();
            }
        } else if (parts.length == 1) {
            result[0] = PHPDocUtils.clean(parts[0]);
        } else if (parts.length == 2) {
            result[0] = PHPDocUtils.clean(parts[0]);
            result[1] = PHPDocUtils.clean(parts[1]);
        } else {
            result[0] = PHPDocUtils.clean(parts[0]);
            result[1] = PHPDocUtils.clean(parts[1]);
            StringBuffer buf = new StringBuffer();
            int i = 2;
            while (i < parts.length) {
                buf.append(parts[i]);
                if (i != parts.length) {
                    buf.append(' ');
                }
                ++i;
            }
            result[2] = buf.toString();
        }
        return result;
    }

    private static String removeCurves(String in) {
        String result = in;
        if (result.startsWith(OPEN_BRACKET)) {
            result = result.substring(1);
        }
        if (result.equals(CLOSE_BRACKET)) {
            return EMPTY_STRING;
        }
        if (result.endsWith(CLOSE_BRACKET)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String clean(String in) {
        String res1 = PHPDocUtils.removeCurves(in);
        return PHPDocUtils.removeDollar(res1);
    }

    private static String removeDollar(String in) {
        if (in.startsWith(DOLLAR)) {
            return in.substring(1);
        }
        return in;
    }

    public static String computeDocumentation(FunctionDocumentation documentation, IDocument document, String name) {
        String additionalInfo = Messages.PHPDocUtils_noAvailableDocs;
        StringBuilder bld = new StringBuilder();
        bld.append("<b>" + name + "</b><br>");
        if (documentation != null) {
            String longDescription = documentation.getDescription();
            longDescription = longDescription.replaceAll("\r\n", "<br>");
            longDescription = longDescription.replaceAll("\r", "<br>");
            if ((longDescription = longDescription.replaceAll("\n", "<br>")).length() > 0) {
                bld.append(longDescription);
                bld.append("<br>");
            }
            TypedDescription[] tagsAsArray = documentation.getParams();
            int a = 0;
            while (a < tagsAsArray.length) {
                bld.append("<br>");
                bld.append("@<b>");
                bld.append("param ");
                bld.append("</b>");
                bld.append(tagsAsArray[a].getName());
                bld.append(' ');
                String[] stringArray = tagsAsArray[a].getTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    bld.append(s);
                    bld.append(' ');
                    ++n2;
                }
                bld.append(' ');
                bld.append(ContentAssistUtils.truncateLineIfNeeded(tagsAsArray[a].getDescription()));
                ++a;
            }
        } else {
            bld.append(additionalInfo);
        }
        if (documentation != null) {
            List<TypedDescription> vars;
            String[] types;
            TypedDescription return1 = documentation.getReturn();
            if (return1 != null && (types = return1.getTypes()).length > 0) {
                bld.append("<br>");
                bld.append("@<b>return </b>");
                bld.append(ContentAssistUtils.truncateLineIfNeeded(return1.getDescription()));
                StringBuilder typesBuilder = new StringBuilder();
                int a = 0;
                while (a < types.length) {
                    typesBuilder.append(types[a]);
                    typesBuilder.append(' ');
                    ++a;
                }
                bld.append(ContentAssistUtils.truncateLineIfNeeded(typesBuilder.toString()));
            }
            if ((vars = documentation.getVars()) != null) {
                for (TypedDescription var : vars) {
                    String[] types2;
                    if (var == null || (types2 = var.getTypes()).length <= 0) continue;
                    bld.append("<br>");
                    bld.append("<b>");
                    bld.append(Messages.PHPDocUtils_documentedType);
                    bld.append("</b>");
                    bld.append(var.getDescription());
                    int a = 0;
                    while (a < types2.length) {
                        bld.append(types2[a]);
                        bld.append(' ');
                        ++a;
                    }
                }
            }
        }
        Matcher inputMatcher = INPUT_TAG_PATTERN.matcher(bld.toString());
        int addedOffset = 0;
        while (inputMatcher.find()) {
            int start = inputMatcher.start();
            int end = inputMatcher.end();
            bld.replace(start + addedOffset, start + addedOffset + 1, "&lt;");
            bld.replace(end + (addedOffset += 2), end + addedOffset + 1, "&gt;");
            addedOffset += 4;
        }
        additionalInfo = bld.toString();
        return additionalInfo;
    }

    /*
     * Unable to fully structure code
     */
    public static List<VarComment> findTypedVarComments(List<Comment> comments, int start, int end) {
        result = new LinkedList<VarComment>();
        commentIndex = PHPDocUtils.findUpperComment(comments, end);
        if (commentIndex < 0) {
            commentIndex = -commentIndex - 1;
        }
        if (commentIndex < comments.size()) ** GOTO lbl11
        return result;
        while ((comment = comments.get(commentIndex)).getStart() >= start) {
            if (comment instanceof VarComment) {
                result.add(0, (VarComment)comment);
            }
            --commentIndex;
lbl11:
            // 2 sources

            if (commentIndex > -1) continue;
        }
        return result;
    }
}

